/* UniPhier On-board interrupt controller registers
 *
 * Copyright (C) 2007 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licence
 * as published by the Free Software Foundation; either version
 * 2 of the Licence, or (at your option) any later version.
 */
#ifndef _ASM_ARCH_INTCTL_REGS_H
#define _ASM_ARCH_INTCTL_REGS_H

#ifdef __KERNEL__

#include <unit/intctl-regs.h>

#ifndef __ASSEMBLY__
extern void mn_intc_set_level(unsigned int irq, unsigned int level);
extern void mn_intc_clear(unsigned int irq);
extern void mn_intc_set(unsigned int irq);
extern void mn_intc_enable(unsigned int irq);
extern void mn_intc_disable(unsigned int irq);
extern void mn_set_lateack_irq_type(int irq);
extern void mn_set_empty_irq_type(int irq);
#define ClearGicr(irq)			mn_intc_clear(irq)			/* deprecated */
#define SetLevelGicr(irq, level)	mn_intc_set_level((irq), (level))	/* deprecated */
#define EnableGicr(irq)			mn_intc_enable(irq)			/* deprecated */
#define DisableGicr(irq)		mn_intc_disable(irq)			/* deprecated */
#endif

#endif /* __KERNEL__ */

#endif /* _ASM_ARCH_INTCTL_REGS_H */
